<?php
// player_api.php - VERSÃO FINAL E CORRIGIDA (EPG Mapeado)
require_once 'config.php';

// Evita sujeira no JSON
ini_set('display_errors', 0);
error_reporting(0);
header('Content-Type: application/json; charset=utf-8');

$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$action   = $_GET['action']   ?? '';
$series_id_req = isset($_GET['series_id']) ? (int)$_GET['series_id'] : 0;

// --- AUTENTICAÇÃO ---
if (!$username || !$password) { die(json_encode([])); }

$stmt = $pdo->prepare("SELECT id, username, password, exp_date, enabled, max_connections, bouquet, is_trial FROM `lines` WHERE username = :u AND password = :p LIMIT 1");
$stmt->execute(['u' => $username, 'p' => $password]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || $user['enabled'] == 0 || $user['exp_date'] < time()) { 
    die(json_encode(['user_info' => ['auth' => 0]])); 
}

// --- FUNÇÕES DE AJUDA ---
function safe_str($val) {
    if ($val === null) return "";
    // Garante UTF-8 para não cortar a sinopse se tiver acento
    return mb_convert_encoding((string)$val, 'UTF-8', 'UTF-8');
}

function format_stream($row, $type) {
    return [
        "num" => (int)$row['num'],
        "name" => safe_str($row['name']),
        "stream_type" => $type,
        "stream_id" => (int)$row['stream_id'],
        "stream_icon" => safe_str($row['stream_icon']),
        "category_id" => safe_str($row['category_id']),
        "added" => safe_str($row['added']),
        "custom_sid" => safe_str($row['custom_sid']),
        // CRÍTICO: O epg_channel_id deve vir da consulta SQL
        "epg_channel_id" => safe_str($row['epg_channel_id']), 
        "direct_source" => "",
        "tv_archive" => 0,
        "tv_archive_duration" => 0,
        "container_extension" => safe_str($row['container_extension'] ?? "mp4")
    ];
}

function format_series($row) {
    return [
        "series_id" => (int)$row['id'],
        "num" => (int)$row['id'],
        "name" => safe_str($row['title']),
        "title" => safe_str($row['title']),
        "cover" => safe_str($row['cover']),
        "stream_icon" => safe_str($row['cover']),
        "category_id" => safe_str($row['category_id']),
        "plot" => safe_str($row['plot']),
        "cast" => safe_str($row['cast']),
        "director" => safe_str($row['director']),
        "genre" => safe_str($row['genre']),
        "releaseDate" => safe_str($row['release_date']),
        "last_modified" => safe_str($row['last_modified']),
        "rating" => safe_str($row['rating']),
        "rating_5based" => 0,
        "backdrop_path" => [safe_str($row['backdrop_path'])],
        "youtube_trailer" => safe_str($row['youtube_trailer']),
        "episode_run_time" => (int)($row['episode_run_time'] ?? 0)
    ];
}

// --- AÇÕES ---

// 1. LOGIN
if ($action == '' || $action == 'get_profile') {
    echo json_encode([
        'user_info' => [
            'username' => $user['username'],
            'password' => $user['password'],
            'message' => 'Login OK',
            'auth' => 1,
            'status' => 'Active',
            'exp_date' => $user['exp_date'],
            'is_trial' => $user['is_trial'],
            'active_cons' => 0,
            'created_at' => time(),
            'max_connections' => $user['max_connections'],
            'allowed_output_formats' => ['m3u8', 'ts', 'rtmp']
        ],
        'server_info' => [
            'url' => $_SERVER['HTTP_HOST'],
            'port' => '80',
            'https_port' => '443',
            'server_protocol' => 'http',
            'rtmp_port' => '8880',
            'timestamp_now' => time(),
            'time_now' => date('Y-m-d H:i:s'),
            'timezone' => 'America/Sao_Paulo'
        ]
    ]);
    exit;
}

// 2. CANAIS - CORREÇÃO DE EPG APLICADA AQUI
if ($action == 'get_live_streams') {
    $sql = "SELECT 
                s.id AS num, 
                s.stream_display_name AS name, 
                s.id AS stream_id, 
                s.stream_icon, 
                s.category_id, 
                s.added, 
                '' AS custom_sid,
                -- CRÍTICO: Pega o EPG ID (o XMLTV ID) da tabela de mapeamento
                COALESCE(ec.name, s.channel_id) AS epg_channel_id 
            FROM streams s
            LEFT JOIN epg_channels ec 
                ON s.id = ec.channel_id -- Junta pelo ID da Stream
            WHERE s.type = 1 
            ORDER BY s.id ASC";
            
    $stmt = $pdo->query($sql);
    $final_result = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $final_result[] = format_stream($row, 'live');
    }
    echo json_encode($final_result);
    exit;
}

// 3. FILMES
if ($action == 'get_vod_streams') {
    $sql = "SELECT id AS num, stream_display_name AS name, id AS stream_id, stream_icon, category_id, target_container as container_extension, added, rating FROM streams WHERE type = 2 ORDER BY added DESC";
    $stmt = $pdo->query($sql);
    $final_result = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $final_result[] = format_stream($row, 'movie');
    }
    echo json_encode($final_result);
    exit;
}

// 4. LISTA DE SÉRIES
if ($action == 'get_series') {
    $sql = "SELECT id, title, category_id, cover, genre, plot, cast, rating, director, release_date, last_modified, backdrop_path, youtube_trailer, episode_run_time FROM streams_series ORDER BY id DESC";
    try {
        $stmt = $pdo->query($sql);
        $final_result = [];
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $final_result[] = format_series($row);
        }
        echo json_encode($final_result);
    } catch (Exception $e) { echo json_encode([]); }
    exit;
}

// 5. DETALHES DA SÉRIE E EPISÓDIOS
if ($action == 'get_series_info') {
    if (!$series_id_req) { echo json_encode([]); exit; }

    // A. Busca Info da Série
    $sqlInfo = "SELECT id, title, cover, plot, cast, director, genre, release_date, rating, backdrop_path, youtube_trailer FROM streams_series WHERE id = :id";
    $stmt = $pdo->prepare($sqlInfo);
    $stmt->execute(['id' => $series_id_req]);
    $seriesRow = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$seriesRow) { echo json_encode([]); exit; }
    
    $backdrop = !empty($seriesRow['backdrop_path']) ? [$seriesRow['backdrop_path']] : [];

    $sinopse_serie = safe_str($seriesRow['plot']);

    $info = [
        "name" => safe_str($seriesRow['title']),
        "cover" => safe_str($seriesRow['cover']),
        "plot" => $sinopse_serie,        
        "description" => $sinopse_serie, 
        "info" => $sinopse_serie,        
        "cast" => safe_str($seriesRow['cast']),
        "director" => safe_str($seriesRow['director']),
        "genre" => safe_str($seriesRow['genre']),
        "releaseDate" => safe_str($seriesRow['release_date']),
        "rating" => safe_str($seriesRow['rating']),
        "backdrop_path" => $backdrop,
        "youtube_trailer" => safe_str($seriesRow['youtube_trailer'])
    ];

    // B. Busca Episódios
    $sqlEps = "SELECT 
                e.id, e.season_num, e.episode_num, e.stream_id,
                s.target_container, s.stream_display_name, s.stream_icon, s.added
               FROM streams_episodes e
               LEFT JOIN streams s ON e.stream_id = s.id
               WHERE e.series_id = :sid
               ORDER BY e.season_num ASC, e.episode_num ASC";
               
    $stmt = $pdo->prepare($sqlEps);
    $stmt->execute(['sid' => $series_id_req]);
    
    $episodes = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (empty($row['stream_id'])) continue;

        $season = (int)$row['season_num'];
        if ($season < 1) $season = 1;

        $img_ep = !empty($row['stream_icon']) ? safe_str($row['stream_icon']) : safe_str($seriesRow['cover']);

        $epData = [
            "id" => (string)$row['stream_id'], 
            "episode_num" => (int)$row['episode_num'],
            "title" => safe_str($row['stream_display_name']),
            "container_extension" => safe_str($row['target_container'] ?? "mp4"),
            "info" => [
                "movie_image" => $img_ep,
                "plot" => $sinopse_serie, 
                "duration" => "00:00:00"
            ],
            "custom_sid" => "",
            "added" => safe_str($row['added']),
            "season" => $season,
            "direct_source" => ""
        ];
        
        $episodes[$season][] = $epData;
    }

    if (empty($episodes)) $episodes = (object)[];

    echo json_encode([
        "seasons" => [], 
        "info" => $info,
        "episodes" => $episodes
    ]);
    exit;
}

// 6. CATEGORIAS - ORDEM CORRIGIDA
if (in_array($action, ['get_live_categories', 'get_vod_categories', 'get_series_categories'])) {
    $typeMap = ['get_live_categories' => 'live', 'get_vod_categories' => 'movie', 'get_series_categories' => 'series'];
    $catType = $typeMap[$action];
    
    $sql = "SELECT id as category_id, category_name, parent_id FROM streams_categories 
            WHERE category_type = '$catType' 
            ORDER BY cat_order ASC"; 

    $result = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    foreach ($result as &$cat) { $cat['category_id'] = (string)$cat['category_id']; }
    echo json_encode($result);
    exit;
}

// 7. EPG COMPLETO (ACTION get_simple_live_events)
if ($action == 'get_simple_live_events') {
    // Busca dados do EPG data
    $sql = "SELECT 
                ed.epg_id, ed.channel_id, ed.title, ed.lang, ed.start, ed.end, ed.description 
            FROM epg_data ed
            -- LEFT JOIN epg_channels ec ON ed.channel_id = ec.name  <-- Esta junção não é necessária aqui, a API precisa de TODOS os eventos EPG
            ORDER BY ed.start DESC LIMIT 20000"; // Limita para evitar travamento

    $stmt = $pdo->query($sql);
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $final_result = [];
    foreach ($events as $event) {
        $final_result[] = [
            "title" => safe_str($event['title']),
            "description" => safe_str($event['description']),
            "start" => (int)$event['start'],
            "end" => (int)$event['end'],
            // CRÍTICO: Usa o channel_id do EPG data, que é o XMLTV ID
            "channel_id" => safe_str($event['channel_id']),
            "epg_id" => (int)$event['epg_id']
        ];
    }
    
    echo json_encode($final_result);
    exit;
}


echo json_encode([]);
?>
